package cn.com.duiba.sso.api.service.power;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.remoteservice.RemoteAdminService;
import cn.com.duiba.sso.api.tool.SystemInfo;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.List;
import java.util.Set;

public class AdminPowerService {

    @Autowired
    private PowerTreeService powerTreeService;
    @Autowired
    private RemoteAdminService remoteAdminService;

    /**
     * 查询拥有某个权限的所有有效角色
     **/
    public List<AdminDto> getHasPowerAdmins(String powerPath){

        PowerTreeCache cache = powerTreeService.getPowerTreeCache(SystemInfo.getThisSystemId());

        Set<Long> pawerIds =  cache.getPowerIdsByUrl(powerPath);
        if(pawerIds.isEmpty()){
            return Collections.emptyList();
        }
        return remoteAdminService.findAdminsByPowerIds(SystemInfo.getThisSystemId(),pawerIds);
    }

}
