package cn.com.duiba.sso.api.tool;

import cn.com.duiba.sso.api.exception.SsoException;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateUtils {

    private static Logger logger = LoggerFactory.getLogger(TemplateUtils.class);


    /**
     * 替换模板变量
     * @param template
     * @param data
     * @return
     */
    public static String replaceArgs(final String template, JSONObject data){
        // sb用来存储替换过的内容，它会把多次处理过的字符串按源字符串序 存储起来。
        StringBuffer sb = new StringBuffer();
        try{
            Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}");
            Matcher matcher = pattern.matcher(template);
            while(matcher.find()){
                String name = matcher.group(1);// 键名
                String value = "";// 键值
                if(data.containsKey(name)){
                    value = data.getString(name);// 键值
                    if(Objects.isNull(value)){
                        throw new SsoException("日志渲染参数为空，模板："+template+"异常参数："+name+"传入参数："+data.toJSONString());
                    }
                    value = value.replaceAll("\\$", "\\\\\\$");
                }
                matcher.appendReplacement(sb, value);
            }
            matcher.appendTail(sb);
        }catch(Exception e){
            logger.error("渲染失败",e);
        }
        return sb.toString();
    }


}
