package cn.com.duiba.sso.api;

import cn.com.duiba.sso.api.domain.properties.SpringApplicationProperties;
import cn.com.duiba.sso.api.domain.properties.SsoBasicProperties;
import cn.com.duiba.sso.api.service.system.DefaultEnvironmentDecisionMaker;
import cn.com.duiba.sso.api.service.system.EnvironmentDecisionMaker;
import cn.com.duiba.sso.api.service.system.EnvironmentEnum;
import cn.com.duiba.sso.api.tool.SystemInfo;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.config.ConfigFileApplicationListener;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableScheduling;

import javax.annotation.Resource;

@Configuration
@EnableScheduling
@EnableConfigurationProperties({SpringApplicationProperties.class, SsoBasicProperties.class})
public class SsoEnvironmentConfiguration {

    @Resource
    private SsoBasicProperties ssoBasicProperties;

    @Bean
    public SystemInfo initSysytem(){
        return new SystemInfo();
    }

    @Bean
    @ConditionalOnMissingBean(EnvironmentDecisionMaker.class)
    public EnvironmentDecisionMaker defaultEnvironmentDecisionMaker(){
        return new DefaultEnvironmentDecisionMaker();
    }

    @Bean
    @Primary
    public EnvironmentEnum defaultEnvironmentEnum(Environment environment){
        EnvironmentEnum environmentEnum = ssoBasicProperties.getEnvironment();
        if(environmentEnum!=null){
            return environmentEnum;
        }
        String profiles = environment.getProperty(ConfigFileApplicationListener.ACTIVE_PROFILES_PROPERTY,"dev");
        return EnvironmentEnum.parseEnvironmentEnum(profiles);
    }

}
