package cn.com.duiba.sso.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sso.api.domain.dto.BusinessLineDto;
import cn.com.duiba.sso.api.domain.enums.AdminBusinessLineRelation;

import java.util.List;
import java.util.Set;

@AdvancedFeignClient
public interface RemoteBusinessLineService {

    /**
     * 获取所有的业务线
     * @return
     */
    List<BusinessLineDto> findAllBusinessLine();

    /**
     * 获取产线负责人列表
     * @param bolId 业务线Id
     * @return 负责人Id
     */
    @Deprecated
    List<Long> findBusinessLineManagers(Long bolId);

    /**
     * 查询一个人管理的所有业务线
     * @param adminId
     * @return
     */
    @Deprecated
    Set<Long> findBusinessLineByAdminId(Long adminId);

    /**
     * 获取产线下管控的应用集合
     * @param bolId 业务线别名
     * @return 业务线的配置集合
     */
    List<String> findBolAppList(Long bolId);

    Set<Long> findBusinessLineIdByAdminIdAndRelation(Long adminId, AdminBusinessLineRelation relation);

    Set<Long> findAdminIdByBusinessLineIdAndRelation(Long businessLineId, AdminBusinessLineRelation relation);

}
