/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.mappingmode;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class SsoMappingModeEnvApplicationInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    public void initialize(ConfigurableApplicationContext application) {
        String mappingMode;
        ConfigurableEnvironment environment = application.getEnvironment();
        MutablePropertySources mutablePropertySources = environment.getPropertySources();
        HashMap<String, String> baseConfig = new HashMap<String, String>();
        MapPropertySource basePropertySource = new MapPropertySource("ssoBaseConfig", baseConfig);
        mutablePropertySources.addFirst((PropertySource)basePropertySource);
        baseConfig.put("application.boot.oauth.host", "https://oauth.dui88.com");
        String environmentForConfig = environment.getProperty("duiba.sso.environment", "");
        if (StringUtils.isNotBlank((String)environmentForConfig)) {
            baseConfig.put("spring.application.environment", environmentForConfig);
        }
        if (!Boolean.valueOf(mappingMode = environment.getProperty("duiba.sso.mapping-mode", "false")).booleanValue()) {
            return;
        }
        String appName = environment.getProperty("spring.application.name");
        if (StringUtils.equals((String)"sso-service", (String)appName)) {
            return;
        }
        String ssoUrl = environment.getProperty("duiba.sso.mapping-sso-url", "sso.duiba.com.cn:443");
        String appSecret = environment.getProperty("duiba.sso.app-secret");
        if (StringUtils.isBlank((String)ssoUrl)) {
            throw new SsoRunTimeException("\u914d\u7f6e:duiba.sso.mapping-sso-url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)appSecret)) {
            throw new SsoRunTimeException("SSO\u6620\u5c04\u6a21\u5f0f\u5fc5\u987b\u914d\u7f6e:duiba.sso.app-secret");
        }
        ssoUrl = ssoUrl.replace("http://", "");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("application.boot.mapping-mode.sso-service", ssoUrl);
        map.put("application.boot.mapping-mode.application-boot", "oauth.dui88.com:443");
        map.put("spring.application.secret", appSecret);
        MapPropertySource propertySource = new MapPropertySource("ssoMappingModeConfig", map);
        mutablePropertySources.addFirst((PropertySource)propertySource);
    }

    public int getOrder() {
        return -2147483638;
    }
}

