package cn.com.duiba.sso.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sso.api.domain.dto.AdminDto;

/**
 * Created by liuyao on 2017/5/10.
 */
@AdvancedFeignClient
public interface RemoteSSOService{

    /**
     * 登录验证接口
     * @return 验证失败返回null
     */
    AdminDto verifyTicketAndGetAdmin(String ticket);

    /**
     * 通过凭证获取的通行证（原来使用链接参数方式跨域传递通行证，不安全）
     * 1.每个系统的凭证只能使用一次
     * 2.并且每个凭证有效期1分钟
     * @param stamp 由链接参数下发的
     */
    String findTicketByStamp(Long systemId,Long stamp);

    /**
     * 全局退出登陆
     */
    Boolean outLogin(String ticket);

    /**
     * 获取Sso域名地址
     */
    String findSsoHomeUrl();

}
