package cn.com.duiba.sso.api.common.interfaces.analysis;

import cn.com.duiba.sso.api.common.interfaces.MethodInfo;
import cn.com.duiba.sso.api.common.interfaces.MethodInfoAnalysis;
import cn.com.duiba.sso.api.common.interfaces.MethodInfoType;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.method.HandlerMethod;

public class SwaggerMethodInfoAnalysis implements MethodInfoAnalysis {

    @Override
    public MethodInfo analysis(HandlerMethod method) {
        ApiOperation apiOperation = method.getMethodAnnotation(ApiOperation.class);
        if(apiOperation==null){
            return null;
        }
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.setName(apiOperation.value());
        methodInfo.setComment(apiOperation.notes());
        methodInfo.getTypeSet().add(MethodInfoType.SWAGGER.name());
        return methodInfo;
    }

    @Override
    public int getOrder() {
        return 50;
    }
}
