package cn.com.duiba.sso.api.common.tree;

import com.google.common.collect.Lists;

import java.util.List;

public abstract class TreeView<T extends TreeNodeShim> extends TreeNodeShim {

    private Long id;

    private Long parentId;

    private List<T> child = Lists.newArrayList();

    @Override
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public List<T> getChild() {
        return child;
    }

    public void setChild(List<T> child) {
        this.child = child;
    }

    public void addChild(T childItem){
        child.add(childItem);
    }
}
