package cn.com.duiba.sso.api.service.logger.runnable;

import cn.com.duiba.sso.api.domain.params.SsoLogParams;
import cn.com.duiba.sso.api.remoteservice.RemoteManagerLogService;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerMateInfo;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerTheadContext;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.tool.TemplateUtils;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * Created by liuyao on 2017/6/19.
 * 异步打印日志
 */
public class SsoLoggerRunnable implements Runnable {

    private static Logger logger = LoggerFactory.getLogger(SsoLoggerRunnable.class);

    private SsoLoggerTheadContext context;

    private SsoLoggerMateInfo mateInfo;

    private RemoteManagerLogService remoteManagerLogService;

    @Override
    public void run() {

        List<JSONObject> paramsList = context.getParams();
        for(JSONObject log:paramsList){
            try{
                JSONObject model = new JSONObject();
                model.put("oprName",mateInfo.getOprName());
                model.put("adminName",mateInfo.getOprName());//兼容老版本
                model.putAll(log);

                String logContext = TemplateUtils.replaceArgs(context.getTemplate(), model);
                SsoLogParams params = new SsoLogParams();
                params.setOprName(mateInfo.getOprName());
                params.setGroup(context.getGroup());
                params.setSystemId(SystemInfo.getThisSystemId());
                params.setIp(mateInfo.getIp());
                params.setParamsJson(log);
                params.setLogContent(logContext);
                remoteManagerLogService.ssoLog(params);
            }catch (Exception e){
                logger.error("操作日志打印失败",e);
            }

        }
    }

    public SsoLoggerTheadContext getContext() {
        return context;
    }

    public void setContext(SsoLoggerTheadContext context) {
        this.context = context;
    }

    public SsoLoggerMateInfo getMateInfo() {
        return mateInfo;
    }

    public void setMateInfo(SsoLoggerMateInfo mateInfo) {
        this.mateInfo = mateInfo;
    }

    public void setRemoteManagerLogService(RemoteManagerLogService remoteManagerLogService) {
        this.remoteManagerLogService = remoteManagerLogService;
    }
}
