package cn.com.duiba.sso.api.common.interfaces.analysis;

import cn.com.duiba.sso.api.common.interfaces.MethodInfo;
import cn.com.duiba.sso.api.common.interfaces.MethodInfoAnalysis;
import cn.com.duiba.sso.api.common.interfaces.MethodInfoType;
import cn.com.duiba.sso.api.service.logger.annotation.SsoLoggerMethod;
import org.springframework.web.method.HandlerMethod;

public class SsoLoggerMethodInfoAnalysis implements MethodInfoAnalysis {
    @Override
    public MethodInfo analysis(HandlerMethod method) {

        SsoLoggerMethod ssoLoggerMethod = method.getMethodAnnotation(SsoLoggerMethod.class);
        if(ssoLoggerMethod==null){
            return null;
        }
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.setName(ssoLoggerMethod.group());
        methodInfo.setComment(ssoLoggerMethod.comment());
        methodInfo.getTypeSet().add(MethodInfoType.SSO_LOG.name());
        return methodInfo;
    }

    @Override
    public int getOrder() {
        return 100;
    }
}
