package cn.com.duiba.sso.api.common.tree;

import org.jetbrains.annotations.NotNull;

import java.io.Serializable;

/**
 * 树形视图的拓片
 */
public abstract class TreeNodeShim implements Serializable,Comparable<TreeNodeShim> {

    private static final long serialVersionUID = -3870646694494456048L;

    private Integer level = 0;

    private int weight = 0;

    public abstract Long getId();

    public abstract Long getParentId();

    public abstract void setParentId(Long parentId);

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public int getWeight() {
        return weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    @Override
    public int compareTo(@NotNull TreeNodeShim o) {
        return Integer.compare(weight, o.weight);
    }

}
