package cn.com.duiba.sso.api.tool;

import cn.com.duiba.application.boot.api.ApplicationProperties;
import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.sso.api.common.interfaces.AppInterfaceAnalysisService;
import cn.com.duiba.sso.api.domain.params.ApplicationInfoParams;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemoteSystemService;
import cn.com.duiba.sso.api.service.SsoApplicationService;
import cn.com.duibaboot.ext.autoconfigure.DuibaBootVersion;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * Created by liuyao on 2017/12/5.
 * 本系统的Mate信息
 */
@Slf4j
public class SystemInfo{


    private static SsoApplicationService ssoSystemService;

    private static RemoteSystemService remoteSystemService;

    private static ApplicationProperties applicationProperties;

    @Resource
    private AppInterfaceAnalysisService appInterfaceAnalysisService;
    @Resource
    private Environment currentEnvironment;

    @EventListener(MainContextRefreshedEvent.class)
    public void MainContextRefreshedEventListener(){
        try{

            if(Objects.equals(currentEnvironment,Environment.DEV)){
                 remoteSystemService.checkAppVersion(DuibaBootVersion.getVersion(),SsoVersion.getVersion());
            }

            String version = SsoVersion.getVersion();
            ApplicationInfoParams params = new ApplicationInfoParams();
            params.setAppName(applicationProperties.getName());
            params.setVersion(version);
            params.setProfiles(currentEnvironment.getEnvId());

            remoteSystemService.submitApplicationInfoParams(params);

            appInterfaceAnalysisService.gatherAppInterfaceInfo();//采集接口信息
        }catch (Exception e){
            log.error("向SSO提交应用原数据失败",e);
        }
    }

    /**
     * 获取本系统的信息
     */
    public static ApplicationDto getThisSystemInfo(){
        return ssoSystemService.getSystemByAlias(applicationProperties.getApplicationName());
    }

    /**
     * 获取本系统的Id
     */
    public static Long getThisSystemId(){
        ApplicationDto system = getThisSystemInfo();
        if(system==null){
            throw new SsoRunTimeException("没有检索到"+applicationProperties.getApplicationName()+"对应的系统配置");
        }
        return system.getId();
    }

    @Autowired
    public void setRemoteSystemService(RemoteSystemService remoteSystemService) {
        SystemInfo.remoteSystemService = remoteSystemService;//NOSONAR
    }

    @Autowired
    public void setSsoSystemService(SsoApplicationService ssoSystemService) {
        SystemInfo.ssoSystemService = ssoSystemService;//NOSONAR
    }

    @Autowired
    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        SystemInfo.applicationProperties = applicationProperties;//NOSONAR
    }

    public static String getSystemAlias(){
        return applicationProperties.getApplicationName();
    }



}