package cn.com.duiba.sso.api.domain.dto;

import com.google.common.collect.Sets;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Optional;
import java.util.Set;

/**
 * Created by liuyao on 2017/5/11.
 */
@Data
public class AdminDto implements Serializable {

    private static final long serialVersionUID = 4264258296954554274L;

    private Long id;

    private String name;

    private String account;

    private String email;//主邮箱

    private String mobile; //手机号

    private String dingUserId; //该用户在钉钉中的Id
    @Deprecated
    private Boolean modelAuthorize = false;//是否通过钉钉手机端授权

    private Integer loginTimeout;//SSO登录有效期（秒）

    private Date gmtCreate;

    private Date gmtModified;

    private Set<Long> systemIdSet = Sets.newHashSet();

    public Boolean getModelAuthorize() {
        return Optional.ofNullable(modelAuthorize).orElse(false);
    }

}
