package cn.com.duiba.sso.api.common.tree;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;

import java.util.*;

/**
 * Created by liuyao on 2017/7/25.
 */
@Slf4j
public class TreeFactory{

    public static <T extends TreeNodeShim> Tree<T> createTree(Long rootId,List<T> entreList){
        List<T> cache = Lists.newLinkedList();
        Tree<T> tree = new Tree<T>(rootId);
        cache.addAll(entreList);
        try{
            int size = cache.size();
            while(size!=0){
                ListIterator<T> items = cache.listIterator();
                while(items.hasNext()){
                    T node = items.next();
                    if(tree.containsId(node.getParentId())){
                        tree.addNode(node);
                        items.remove();
                    }
                }
                if(cache.size()==size){
                    Set<Long> parent = Sets.newHashSet();
                    for(T item:cache){
                        parent.add(item.getParentId());
                    }
                    throw new RuntimeException("创建树时，存在无父节点的子节点:"+ JSONObject.toJSONString(parent));
                }
                size = cache.size();
            }
        }catch(Exception e){
            log.error("数据库中父子关系异常",e);
            throw new RuntimeException("数据库中父子关系异常",e);
        }
        return tree;
    }

    public static <T extends TreeNodeShim> Tree<T> createTree(List<T> entreList){
        return createTree(0L,entreList);
    }

    /**
     * 把树转化成二维的树形视图
     */
    public static <T extends TreeView<T>> List<T> transformTree(Tree<T> tree){
        if(tree.size()==0){
            return Collections.emptyList();
        }
        List<T> viewList = Lists.newArrayList();
        List<T> list = tree.getTreeView();

        Stack<T> stack = new Stack<>();

        for(T item : list){
            //第一个加入
            if(stack.isEmpty() && item.getLevel()==1){
                stack.push(item);
                viewList.add(item);
                continue;
            }
            T top = stack.peek();
            long levelDifference = top.getLevel() - item.getLevel();
            for(int i=0;i<=levelDifference;i++){
                stack.pop();
            }
            if(stack.isEmpty()){
                viewList.add(item);
            }else{
                stack.peek().addChild(item);
            }
            stack.push(item);
        }
        return viewList;
    }

}
