package cn.com.duiba.sso.api.domain.dto;

import com.google.common.collect.Sets;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Optional;
import java.util.Set;

/**
 *
 * @author liuyao
 * @date 2017/5/11
 */
@Data
public class AdminDto implements Serializable {

    private static final long serialVersionUID = 4264258296954554274L;

    private Long id;

    private String name;

    private String account;
    /**
     * 主邮箱
     */
    private String email;
    /**
     * 手机号
     */
    private String mobile;
    /**
     * 该用户在钉钉中的Id @user RemoteDingdingService.getDingdingUserIdByAdminId
     */
    @Deprecated
    private String dingUserId;
    /**
     * 是否通过钉钉手机端授权
     */
    @Deprecated
    private Boolean modelAuthorize = false;
    /**
     * SSO登录有效期（秒）
     */
    private Integer loginTimeout;

    private Date gmtCreate;

    private Date gmtModified;

    /**
     * 请使用 @use RemotePermissionService.canAccessSystem
     */
    @Deprecated
    private Set<Long> systemIdSet = Sets.newHashSet();

    public Boolean getModelAuthorize() {
        return Optional.ofNullable(modelAuthorize).orElse(false);
    }

}
