package cn.com.duiba.sso.api.domain.params;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * sso操作日志参数
 * @author liuyao
 */
@Data
public class OprLogParams implements Serializable {

    @Deprecated
    private String uuid;
    /**
     * 应用id
     */
    @NotNull
    private Long appId;
    /**
     * 操作人的id
     */
    @NotNull
    private Long adminId;
    /**
     * 日志编组
     */
    @NotBlank
    private String group;
    /**
     * 提交日志的ip
     */
    @NotBlank
    private String ip;
    /**
     * 会造成反序列化失败 请使用 params
     */
    @Deprecated
    private JSONObject paramsJson;
    /**
     * 日志参数
     */
    private String params;
    /**
     * 渲染后的日志正文
     */
    private String logContent;
    /**
     * 日志发生时间
     */
    private Date actionTime;

}
