package cn.com.duiba.sso.api.service.logger.service;

import cn.com.duiba.sso.api.domain.params.OprLogParams;
import cn.com.duiba.sso.api.service.logger.appender.SsoLogAppender;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerMateInfo;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerStackFrame;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerTheadContext;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.tool.TemplateUtils;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;

import java.util.Date;
import java.util.List;

/**
 * @author liuyao
 * @date 2017/6/19
 * 异步打印日志
 */
@Slf4j
public class SsoLoggerRunnable implements Runnable {

    private SsoLoggerStackFrame stackFrame;

    private List<SsoLogAppender> logAppenders;

    @Override
    public void run() {
        JSONObject model = stackFrame.getParams();
        String logContext = TemplateUtils.replaceArgs(stackFrame.getTemplate(), model);

        OprLogParams params = new OprLogParams();
        params.setAppId(SystemInfo.getThisSystemId());
        params.setAdminId(stackFrame.getAdminId());
        params.setGroup(stackFrame.getGroup());
        params.setIp(stackFrame.getIp());
        params.setParams(model.toJSONString());
        params.setLogContent(logContext);
        params.setActionTime(new Date());

        for(SsoLogAppender appender:logAppenders){
            try {
                //复制参数，防止在 appender 中修改参数，使日志失去真实性
                OprLogParams clone = new OprLogParams();
                BeanUtils.copy(params,clone);
                appender.acceptOperationLog(params);
            }catch (Exception e){
                log.error("Class[{}]处理操作日志失败",appender.getClass().getSimpleName(),e);
            }
        }
    }

    public void setLogAppenders(List<SsoLogAppender> logAppenders) {
        this.logAppenders = logAppenders;
    }

    public void setStackFrame(SsoLoggerStackFrame stackFrame) {
        this.stackFrame = stackFrame;
    }
}
