package cn.com.duiba.sso.api.service.logger.service;


import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerStackFrame;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Objects;
import java.util.Stack;

/**
 * @author liuyao
 */
public class SsoLoggerStackContext {

    private final Stack<SsoLoggerStackFrame> loggerStack = new Stack<>();

    public void addLogParam(JSONObject param) {
        SsoLoggerStackFrame context = getCurrentStackFrame();
        context.addParam(param);
    }

    public void addLogParam(String key,Object value){
        SsoLoggerStackFrame context = getCurrentStackFrame();
        context.addParam(key,value);
    }

    private SsoLoggerStackFrame getCurrentStackFrame(){
        SsoLoggerStackFrame frame = loggerStack.peek();
        if(Objects.isNull(frame)){
            throw new UnsupportedOperationException("当前方法未处于业务切面,无法获取日志栈");
        }
        return frame;
    }

    protected SsoLoggerStackFrame popStackFrame() {
        if (loggerStack.isEmpty()) {
            return null;
        }
        return loggerStack.pop();
    }

    protected void addStackFrame(SsoLoggerStackFrame frame) {
        loggerStack.push(frame);
    }

    protected boolean isEmpty(){
        return loggerStack.isEmpty();
    }
}
