/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service.logger.service;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.sso.api.service.logger.annotation.SsoLoggerMethod;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerStackFrame;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerService;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;

@Aspect
public class SsoLoggerInterceptor {
    @Resource
    private SsoLoggerService ssoLoggerService;
    public static final String RESPONSE = "response";
    private final LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();

    @Around(value="@annotation(cn.com.duiba.sso.api.service.logger.annotation.SsoLoggerMethod)")
    public Object logger(ProceedingJoinPoint point) throws Throwable {
        Object paramNames;
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        SsoLoggerMethod loggerMethod = (SsoLoggerMethod)AnnotationUtils.findAnnotation((Method)method, SsoLoggerMethod.class);
        String template = Objects.requireNonNull(loggerMethod).value();
        String group = loggerMethod.group();
        if (StringUtils.isBlank((String)template)) {
            throw new IllegalArgumentException("\u64cd\u4f5c\u65e5\u5fd7: " + group + ", template\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SsoLoggerStackFrame frame = new SsoLoggerStackFrame();
        frame.setTemplate(template);
        frame.setGroup(group);
        this.ssoLoggerService.initStackContext(frame);
        if (loggerMethod.request()) {
            Object[] arguments = point.getArgs();
            paramNames = this.discoverer.getParameterNames(method);
            for (int i = 0; i < Objects.requireNonNull(paramNames).length; ++i) {
                String paramName = paramNames[i];
                Object value = arguments[i];
                if (!(value instanceof Serializable)) continue;
                frame.addParam(paramName, value);
            }
        }
        try {
            Object result = point.proceed();
            if (loggerMethod.response() && result instanceof Serializable) {
                frame.addParam(RESPONSE, result);
            }
            paramNames = result;
            return paramNames;
        }
        catch (Exception e) {
            Throwable exception = e;
            while (exception instanceof InvocationTargetException) {
                exception = ((InvocationTargetException)exception).getTargetException();
            }
            frame.setErrorLog(!(exception instanceof BizException));
            if (StringUtils.isNotBlank((String)e.getMessage())) {
                String msg = e.getMessage().length() > 1000 ? e.getMessage().substring(0, 1000) : e.getMessage();
                frame.addParam(RESPONSE, msg);
            }
            throw e;
        }
        finally {
            this.ssoLoggerService.flushThreadContext();
        }
    }
}

