package cn.com.duiba.sso.api;

import cn.com.duiba.sso.api.common.interfaces.AppInterfaceAnalysisConfiguration;
import cn.com.duiba.sso.api.service.SsoApplicationService;
import cn.com.duiba.sso.api.service.logger.SsoLoggerConfiguration;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerService;
import cn.com.duiba.sso.api.service.power.AdminPowerCacheService;
import cn.com.duiba.sso.api.service.power.PowerTreeService;
import cn.com.duiba.sso.api.service.power.SsoResourceFieldFilter;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duibaboot.ext.autoconfigure.threadpool.policy.AbortPolicyWithReport;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableScheduling;

import java.util.concurrent.*;

/**
 * @author liuyao
 */
@EnableScheduling
@Import({
        AppInterfaceAnalysisConfiguration.class,
        SsoLoggerConfiguration.class
})
public class SsoBasicConfiguration {

    @Bean
    public SystemInfo initSysytem(){
        return new SystemInfo();
    }

    @Bean
    public SsoApplicationService ssoSystemService(){
        return new SsoApplicationService();
    }

    @Bean
    public PowerTreeService powerTreeService(){
        return new PowerTreeService();
    }

    @Bean
    public SsoResourceFieldFilter ssoResourceFieldFilter(){
        return new SsoResourceFieldFilter();
    }

    @Bean
    public AdminPowerCacheService adminPowerCacheService(){
        return new AdminPowerCacheService();
    }

    @Bean
    public ExecutorService ssoExecutorService(){
        BlockingQueue<Runnable> queue = new ArrayBlockingQueue<>(500);
        return new ThreadPoolExecutor(10,40,
                60L, TimeUnit.SECONDS,
                queue,
                new NamedThreadFactory("sso"),
                new AbortPolicyWithReport());
    }

}
