package cn.com.duiba.sso.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sso.api.domain.dto.AdminGroupDto;
import cn.com.duiba.sso.api.domain.dto.AdminGroupInfoDto;
import cn.com.duiba.sso.api.domain.dto.AdminGroupLeaderDto;
import cn.com.duiba.sso.api.domain.dto.GroupMemberDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAdminGroupService {

    /**
     * 根据KEY来查询业务系统指定的根级组织
     * @param groupKey 组织唯一识别符
     */
    AdminGroupDto findRootGroupByKey(String groupKey);

    /**
     * 获取以groupId为根组织所有用户的信息
     * @User findGroupMembers
     * @param systemId 系统
     * @param groupId 组ID
     */
    @Deprecated
    List<AdminGroupInfoDto> findGroupAdminInfo(Long groupId,Long systemId);

    /**
     * 获取以groupId为根组织所有成员的信息
     * @param groupId
     * @return
     */
    List<GroupMemberDto> findGroupMembersByRootGroupId(Long groupId);


    /**
     * 查询当前组织的直直属子级组织
     * @param groupId 组织Id
     */
    List<AdminGroupDto> findChildGroupBykey(Long groupId);

    /**
     * 查询指定根组织中，员工所存在的全部组织
     * @param groupId 组织Id
     * @param adminId 员工Id
     */
    List<AdminGroupDto> selectGroupForAdmin(Long groupId,Long adminId);

    /**
     * 获取员工所在组织的leader
     * @param adminId 员工Id
     * @param tagId 标签
     * @return
     */
    List<AdminGroupLeaderDto> findAdminGroupLeader(Long adminId,Long tagId);
}


