package cn.com.duiba.sso.api.service.logger.appender;

import cn.com.duiba.sso.api.domain.params.OprLogParams;
import cn.com.duiba.sso.api.remoteservice.RemoteManagerLogService;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

/**
 * 通过远程接口向Sso上报操作日志
 * @author liuyao
 */
@Slf4j
public class SsoLogRpcAppender implements SsoLogAppender {


    @Resource
    private RemoteManagerLogService remoteManagerLogService;

    @Override
    public void acceptOperationLog(OprLogParams params) {
        try{
            remoteManagerLogService.operationLog(params);
        }catch (Exception e){
            log.error("sso操作日志记录失败",e);
        }
    }
}
