package cn.com.duiba.sso.api.service.logger.service;

import cn.com.duiba.sso.api.service.logger.SsoLogger;
import cn.com.duiba.sso.api.service.logger.appender.SsoLogAppender;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerMateInfo;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerStackFrame;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;

/**
 *
 * @author liuyao
 * @date 2017/6/19
 */
public class SsoLoggerService implements InitializingBean {

    @Resource(name= "ssoExecutorService")
    private ExecutorService ssoExecutorService;
    @Autowired(required = false)
    private SsoLoggerMateInfoAdapter ssoLoggerMateInfoAdapter;
    @Autowired
    private List<SsoLogAppender> ssoLogAppenderList;

    /**
     * 由切面产生,如果没有此日志线程对象,则SsoLogger的无法打印日志
     */
    private final ThreadLocal<SsoLoggerStackContext> threadContext = new ThreadLocal<>();

    @Override
    public void afterPropertiesSet(){
        SsoLogger.setSsoLoggerService(this);
    }

    /**
     * 初始化 stackContext
     */
    protected void initStackContext(SsoLoggerStackFrame frame) {
        SsoLoggerStackContext context = threadContext.get();
        if (Objects.isNull(context)) {
            context = new SsoLoggerStackContext();
            threadContext.set(context);
        }
        context.addStackFrame(frame);
    }

    public SsoLoggerStackContext getSsoLoggerStackContext() {
        SsoLoggerStackContext context = threadContext.get();
        if(Objects.isNull(context)){
            throw new UnsupportedOperationException("当前线程没有位于Sso操作日志切面中");
        }
        return context;
    }

    /**
     * 打印业务日志
     * 封装 task 异步线程池执行
     */
    protected void flushThreadContext() {
        SsoLoggerStackContext stackContext = threadContext.get();
        if (Objects.isNull(stackContext)) {
            return;
        }
        SsoLoggerStackFrame frame = stackContext.popStackFrame();
        if (stackContext.isEmpty()) {
            threadContext.remove();
        }
        if(Objects.isNull(frame)){
            return;
        }
        if(ssoLoggerMateInfoAdapter==null){
            return;
        }
        SsoLoggerMateInfo mateInfo = ssoLoggerMateInfoAdapter.getLoggerMateInfo();
        frame.setIp(mateInfo.getIp());
        frame.setAdminId(mateInfo.getAdminId());

        SsoLoggerRunnable runnable = new SsoLoggerRunnable();
        runnable.setStackFrame(frame);
        runnable.setLogAppenders(ssoLogAppenderList);
        ssoExecutorService.submit(runnable);
    }

}
