package cn.com.duiba.sso.api.service.power;

import java.lang.annotation.*;

/**
 * 字段权限校验注解
 *
 * 与SsoResourceFieldFilter配合使用
 *
 * 用在普通属性上，当检验的结果为没有权限的时候，会以null替换字段的值，当字段属性为字符串，会以replace的值进行替换
 * 当用在集合属性上时，无权限会清空当前集合字段，有权限时会继续深层校验该集合
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Documented
public @interface SsoResourceField {

    /**
     * 对应sso的资源，如果为空字符串，权限校验结果为有权限
     */
    String value() default "";

    /**
     * 如果对应的字段为String 当被sso权限系统拦截，则可以替换成指定的内容
     */
    String replace() default "--";

}
