package cn.com.duiba.sso.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sso.api.domain.dto.PowerDto;
import cn.com.duiba.sso.api.domain.dto.RoleDto;

import java.util.List;
import java.util.Set;

/**
 *
 * @author liuyao
 * @date 2017/7/4
 */
@AdvancedFeignClient
public interface RemotePermissionService {

    /**
     * 是否具有应用的访问权限
     */
    Boolean canAccessSystem(String appAlias, Long adminId);

    /**
     * 获取一个用户在一个系统下所有的角色
     * @param systemId 系统Id
     * @param adminId 员工Id
     * 过时理由：角色所为sso内部概念，不对外进行开放
     */
    @Deprecated
    List<RoleDto> getAdminAllRoles(Long systemId,Long adminId);

    /**
     * 加载一个系统下所有的角色
     * @param systemId 系统Id
     * @return 角色列表
     * 过时理由：角色所为sso内部概念，不对外进行开放
     */
    @Deprecated
    List<RoleDto> getApplicationAllRoles(Long systemId);

    /**
     * 加载角色下勾选的资源Id
     * @param roleId 角色Id
     * @return 资源ids
     * 过时理由：角色所为sso内部概念，不对外进行开放
     */
    @Deprecated
    List<Long> findPowerIdsForRoleId(Long roleId);

    /**
     * 获取管理员在指定系统下的权限
     * @param systemId 系统Id
     * @param adminId 员工Id
     * @return 用户在系统下
     **/
    Set<Long> getPowerIdsBySystemIdAndAdminId(Long systemId,Long adminId);

    /**
     * 获取管理员权限配置的版本号
     * @param systemId 系统Id
     * @param adminId 员工Id
     */
    Long getAdminPowerVersion(Long systemId,Long adminId);

    /**
     * 加载权限树
     * @param systemId 系统
     * @return 权限树
     */
    List<PowerDto> loadPowerList(Long systemId);

    /**
     * 获取系统的权限树的版本号
     * @param systemId 系统Id
     * @return 系统权限版本
     */
    Long getSystemPowerVersion(Long systemId);

}
