package cn.com.duiba.sso.api.service;

import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import cn.com.duiba.application.boot.api.remoteservice.RemoteApplicationService;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;
import java.util.concurrent.TimeUnit;

/**
 * @author liuyao
 */
@Slf4j
public class SsoApplicationService {

    @Resource
    private RemoteApplicationService remoteApplicationService;

    private final LoadingCache<String, ApplicationDto> cache = Caffeine.newBuilder()
            .expireAfterWrite(1, TimeUnit.MINUTES)
            .build((systemName)->{
                ApplicationDto application = remoteApplicationService.getApplicationByAlias(systemName);
                if(application==null){
                    log.error("systemName:"+systemName+"没有对应的系统配置");
                }
                return application;
            });

    public ApplicationDto getSystemByAlias(String systemAlias){
        return cache.get(systemAlias);
    }

}
