package cn.com.duiba.sso.api.service.logger.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 *
 * @author liuyao
 * @date 2017/6/19
 * SsoLogger注解,主要规定日志的模板和指定日志的编组
 * 不支持日志嵌套,如果存在嵌套,以最外层SsoLogger配置为准
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface SsoLoggerMethod {
    /**
     * 日志模板
     * 在模板中可以直接使用的参数${adminId}、${adminName}
     */
    String value() default "";

    String group() default "默认";

    String comment() default "";

    /**
     * 记录 request 变量
     * 并发入参以参数名为key加入到日志
     * 注意：对应的参数类型需要实现序列化接口才会被加入到参数中
     */
    boolean request() default false;

    /**
     * 记录返回结果
     * 注意：返回类型需要实现序列化接口才会被加入到参数中
     */
    boolean response() default false;

}
