package cn.com.duiba.sso.api.remoteservice;

import org.springframework.web.bind.annotation.RequestMapping;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by liuyao on 2017/5/10.
 */
@AdvancedFeignClient
public interface RemoteSSOService{

    /**
     * 登录验证接口
     * @param ticket
     * @return
     */
    DubboResult<AdminDto> verifyTicketToAdmin(String ticket);

    /**
     * 生成全局通行令牌
     * @param adminId
     * @return
     */
    DubboResult<String> createTicket(Long adminId);

    /**
     * 全局退出登陆
     * @param ticket
     * @return
     */
    DubboResult<Boolean> removeTicket(String ticket);

    /**
     * 删除权限缓存(内部自行清理)
     * @param ticket
     * @return
     */
    @Deprecated
    @RequestMapping("/removePermissionCacheByTidSid")
    DubboResult<Boolean> removePermissionCache(String ticket,int systemId);
}
