package cn.com.duiba.sso.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by liuyao on 2017/5/12.
 */
@AdvancedFeignClient
public interface RemoteAdminService {
    /**
     * 获取管理员
     * @param id
     * @return
     */
    DubboResult<AdminDto> findAdmin(Long id);

    /**
     *
     * @return
     */
    @Deprecated
    DubboResult<List<AdminDto>> findAdmins(int systemId,String roleName);

    /**
     * 按系统和角色名称检索管理员
     * @param systemId
     * @param roleName
     * @return
     */
    List<AdminDto> findAdminsByRoleName(Long systemId,String roleName);


    /**
     * 验证谷歌动态码
     * @param adminId
     * @param code
     * @return
     */
    DubboResult<Boolean> googleVerify(Long adminId,String code);

    /**
     * 批量查询管理员
     * @param ids
     * @return
     */
    DubboResult<List<AdminDto>> findAdminByIds(List<Long> ids);

    /**
     * 根据角色ID查询所有的管理员
     * @param roleIds
     * @return
     */
    DubboResult<List<AdminDto>> findAdminByRoleId(List<Long> roleIds);

}
