package cn.com.duiba.sso.api.common.tree;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;

/**
 * Created by liqing on 2017/7/24.
 */
public class Tree<T extends TreeNodeShim> implements Serializable{

    private static final long serialVersionUID = -76043282162474212L;
    //树形视图,根节点
    private TreeNode rootNode = new TreeNode(0L,0L);

    private Map<Long,T> objMap = Maps.newConcurrentMap();

    private ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    Tree(){}

    public boolean containsId(Long id){
        return rootNode.containsId(id);
    }

    public int size(){
        return rootNode.getChildSize();
    }

    public void addNode(T shim) throws Exception{
        try{
            readWriteLock.writeLock().lock();
            TreeNode node = new TreeNode(shim.getId(),shim.getParentId());
            rootNode.addChildNode(node);
            objMap.put(shim.getId(),shim);
        }finally{
            readWriteLock.writeLock().unlock();
        }
    }
    /**
     * 删除子节点，如果删除的节点存在子节点，则抛出异常
     * 如果树中已经导入了实体类，则在删除节点的同时，删除节点对应的实体
     * @param nodeId 要删除的子节点Id
     * @throws Exception
     */
    public void deleteNode(Long nodeId) throws Exception{
        try{
            readWriteLock.writeLock().lock();
            if(rootNode.containsId(nodeId)){
                rootNode.deleteChildNode(nodeId);
                objMap.remove(nodeId);
            }
        }catch(Exception e){
            throw e;
        }finally{
            readWriteLock.writeLock().unlock();
        }
    }

    /**
     * 获取完整的树形视图
     * @return
     */
    public List<T> getTreeView(){
        try{
            readWriteLock.readLock().lock();
            List<TreeNode> list = rootNode.getAllNode();
            return list.stream().map((node) -> {
                T shim = objMap.get(node.getId());
                shim.setLevel(node.getLevel());
                return shim;
            }).collect(Collectors.toList());
        }finally{
            readWriteLock.readLock().unlock();
        }
    }

    /**
     * 获取单节点
     * @param nodeId
     * @return
     */
    public T getNode(Long nodeId){
        return objMap.get(nodeId);
    }


    /**
     * 获取根节点到目的节点视图
     * @param destNodeId 目的节点的Id
     * @return
     */
    public List<T> getOneWayView(Long destNodeId){
        List<Long> idSequence = Lists.newArrayList();
        rootNode.findNodeWay(destNodeId,idSequence);
        return idSequence.stream().map((id) -> {
            return objMap.get(id);
        }).collect(Collectors.toList());
    }

}
