package cn.com.duiba.sso.api.common.tree;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

/**
 * Created by liuyao on 2017/7/25.
 */
public class TreeFactory{

    private static Splitter splitter = Splitter.on(",").trimResults().omitEmptyStrings();

    public static <T extends TreeNodeShim> Tree<T> createTree(Long rootId,List<T> entreList){
        List<T> cache = Lists.newLinkedList();
        Tree<T> tree = new Tree<T>(rootId);
        cache.addAll(entreList);
        try{
            int size = cache.size();
            while(size!=0){
                ListIterator<T> items = cache.listIterator();
                while(items.hasNext()){
                    T node = items.next();
                    if(tree.containsId(node.getParentId())){
                        tree.addNode(node);
                        items.remove();
                    }
                }
                if(cache.size()==size){
                    throw new RuntimeException("创建树时，存在无父节点的子节点");
                }
                size = cache.size();
            }
        }catch(Exception e){
            throw new RuntimeException("数据库中父子关系异常");
        }
        return tree;
    }

    public static <T extends TreeNodeShim> Tree<T> createTree(List<T> entreList){
        return createTree(0L,entreList);
    }

    /**
     * 把树转化成二维的树形视图
     */
    public static <T extends TreeView<T>> List<T> transformTree(Tree<T> tree){
        if(tree.size()==0){
            return Collections.emptyList();
        }
        List<T> viewList = Lists.newArrayList();
        List<T> list = tree.getTreeView();

        Stack<T> stack = new Stack<>();

        for(T item : list){
            //第一个加入
            if(stack.isEmpty() && item.getLevel()==1){
                stack.push(item);
                viewList.add(item);
                continue;
            }
            T top = stack.peek();
            long levelDifference = top.getLevel() - item.getLevel();
            for(int i=0;i<=levelDifference;i++){
                stack.pop();
            }
            if(stack.isEmpty()){
                viewList.add(item);
            }else{
                stack.peek().addChild(item);
            }
            stack.push(item);
        }
        return viewList;
    }

    public static <T extends TreeNodeShim,S extends TreeNodeIndexShim> List<T> transformTreeNode(List<S> sourceList, Function<S,T> handler){
        if(sourceList==null){
            return Collections.emptyList();
        }
        return sourceList.stream().map((source)->{
            T dest = handler.apply(source);

            List<String> idStrList = splitter.splitToList(source.getTreeIndex());

            dest.setLevel(idStrList.size());
            dest.setParentId(idStrList.isEmpty()?0L:Long.valueOf(idStrList.get(idStrList.size()-1)));

            return dest;
        }).collect(Collectors.toList());
    }


}
