package cn.com.duiba.sso.api.common.tree;

import com.google.common.base.Joiner;
import org.apache.commons.lang.StringUtils;

/**
 * 数据库树形索引，以逗号分隔所有祖辈的节点id,层级数等级索引中ID的个数
 */
public interface TreeNodeIndexShim {

    static Joiner joiner = Joiner.on(",").skipNulls();

    public Long getId();

    public String getTreeIndex();

    /**
     * 获取用于查询后代的索引
     * @return
     */
    public default String getSelectTreeIndex(){
        String treeIndex = getTreeIndex();
        treeIndex = StringUtils.isBlank(treeIndex)?null:treeIndex;
        return joiner.join(treeIndex,getId());
    }

}
