package cn.com.duiba.sso.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sso.api.domain.dto.AdminGroupDto;
import cn.com.duiba.sso.api.domain.dto.AdminGroupInfoDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAdminGroupService {

    /**
     * 获取以groupId为根组织所有用户的信息
     * @param systemId 系统
     * @param groupId 组ID
     * @return
     */
    public List<AdminGroupInfoDto> findGroupAdminInfo(Long groupId,Long systemId);

    /**
     * 获取以groupKey为根组织所有用户的信息
     * @param systemId 系统
     * @param groupKey
     * @return
     */
    public List<AdminGroupInfoDto> findGroupAdminInfoByGroupKey(String groupKey,Long systemId);

    /**
     * 查询当前组织的直直属子级组织
     * @param groupKey
     * @return
     */
    public List<AdminGroupDto> findChildGroupBykey(String groupKey);

    /**
     * 查询指定根组织中，员工所存在的全部组织
     * @param rootGroupKey
     * @param adminId
     * @return
     */
    public List<AdminGroupDto> selectGroupForAdmin(String rootGroupKey,Long adminId);


}


