/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.common.tree;

import cn.com.duiba.sso.api.common.tree.TreeNodeShim;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TreeNode
extends TreeNodeShim
implements Serializable {
    protected static final Long VIRTUAL_PARENT_ID = -1L;
    private Long id;
    private Long parentId;
    private Map<Long, TreeNode> childMap = Maps.newLinkedHashMap();
    private Map<Long, Set<Long>> allChildId = Maps.newHashMap();

    TreeNode(Long id, Long parentId) {
        this.id = id;
        this.parentId = parentId;
    }

    public void addChildNode(TreeNode node) {
        Long cparentId = node.getParentId();
        if (this.id.equals(cparentId)) {
            node.setLevel(this.getLevel() + 1);
            this.childMap.put(node.getId(), node);
            this.putChildValue(node.getId(), node.getId());
            return;
        }
        if (this.containsChildValue(cparentId)) {
            TreeNode childNode = this.findChildNode(cparentId);
            this.putChildValue(childNode.getId(), node.getId());
            childNode.addChildNode(node);
        }
    }

    private boolean containsChildValue(Long destId) {
        return this.findChildNode(destId) != null;
    }

    private void putChildValue(Long childId, Long destId) {
        if (!this.allChildId.containsKey(childId)) {
            this.allChildId.put(childId, Sets.newHashSet());
        }
        this.allChildId.get(childId).add(destId);
    }

    private void removeChildValue(Long childId, Long destId) {
        if (!this.allChildId.containsKey(childId)) {
            return;
        }
        this.allChildId.get(childId).remove(destId);
    }

    private TreeNode findChildNode(Long destId) {
        for (Long childId : this.allChildId.keySet()) {
            if (!this.allChildId.get(childId).contains(destId)) continue;
            return this.childMap.get(childId);
        }
        return null;
    }

    public void deleteChildNode(Long destId) throws Exception {
        if (this.childMap.containsKey(destId)) {
            if (this.childMap.get(destId).hasChild()) {
                throw new Exception("\u5b58\u5728\u5b50\u8282\u70b9\uff0c\u4e0d\u80fd\u5220\u9664");
            }
            this.removeChildValue(destId, destId);
            this.childMap.remove(destId);
            return;
        }
        if (this.containsChildValue(destId)) {
            TreeNode childNode = this.findChildNode(destId);
            childNode.deleteChildNode(destId);
            this.removeChildValue(childNode.getId(), destId);
        }
    }

    public List<TreeNode> getAllNode() {
        LinkedList nodeList = Lists.newLinkedList();
        if (!Objects.equals(this.parentId, VIRTUAL_PARENT_ID)) {
            nodeList.add(this);
        }
        if (this.hasChild()) {
            for (TreeNode childNode : this.childMap.values()) {
                nodeList.addAll(childNode.getAllNode());
            }
        }
        return nodeList;
    }

    public int getChildSize() {
        return this.allChildId.size();
    }

    public boolean hasChild() {
        return !this.childMap.isEmpty();
    }

    public boolean containsId(Long id) {
        return !Objects.equals(null, this.id) && this.id.equals(id) || this.containsChildValue(id);
    }

    public void findNodeWay(Long destId, List<Long> nodeWayList) {
        if (!this.containsId(destId)) {
            return;
        }
        if (!Objects.equals(this.parentId, VIRTUAL_PARENT_ID)) {
            nodeWayList.add(this.id);
        }
        if (this.containsChildValue(destId)) {
            TreeNode childNode = this.findChildNode(destId);
            childNode.findNodeWay(destId, nodeWayList);
        }
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Long getParentId() {
        return this.parentId;
    }

    @Override
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
}

