package cn.com.duiba.sso.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sso.api.domain.dto.AdminGroupDto;
import cn.com.duiba.sso.api.domain.dto.AdminGroupInfoDto;

import java.util.List;

@SsoInterface(RemoteAdminGroupService.class)
@AdvancedFeignClient
public interface RemoteAdminGroupService {

    /**
     * 根据KEY来查询业务系统指定的根级组织
     * @param groupKey
     * @return
     */
    public AdminGroupDto findRootGroupByKey(String groupKey);

    /**
     * 获取以groupId为根组织所有用户的信息
     * @param systemId 系统
     * @param groupId 组ID
     * @return
     */
    public List<AdminGroupInfoDto> findGroupAdminInfo(Long groupId,Long systemId);

    /**
     * 查询当前组织的直直属子级组织
     * @param groupId
     * @return
     */
    public List<AdminGroupDto> findChildGroupBykey(Long groupId);

    /**
     * 查询指定根组织中，员工所存在的全部组织
     * @param groupId
     * @param adminId
     * @return
     */
    public List<AdminGroupDto> selectGroupForAdmin(Long groupId,Long adminId);


}


