package cn.com.duiba.sso.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Set;

/**
 * Created by liuyao on 2017/5/12.
 */
@SsoInterface(RemoteAdminService.class)
@AdvancedFeignClient
public interface RemoteAdminService {

    @Deprecated
    DubboResult<AdminDto> findAdmin(Long id);

    /**
     * 获取管理员
     * @param id
     * @return
     */
    AdminDto findOneAdmin(Long id);

    /**
     * 按系统和角色名称检索管理员
     * @param systemId
     * @param roleName
     * @return
     */
    List<AdminDto> findAdminsByRoleName(Long systemId,String roleName);

    /**
     * 查出拥有权限所有管理员
     * @param systemId
     * @param powerIds
     * @return
     */
    List<AdminDto> findAdminsByPowerIds(Long systemId, Set<Long> powerIds);

    @Deprecated
    DubboResult<Boolean> googleVerify(Long adminId,String code);

    /**
     * 验证谷歌动态码
     * @param adminId
     * @param code
     * @return
     */
    Boolean googleCodeVerify(Long adminId,String code);

    @Deprecated
    DubboResult<List<AdminDto>> findAdminByIds(List<Long> ids);

    /**
     * 批量查询管理员
     * @param ids
     * @return
     */
    List<AdminDto> batchFindAdminByIds(List<Long> ids);

    DubboResult<List<AdminDto>> findAdminByRoleId(List<Long> roleIds);

    /**
     * 根据角色ID查询所有的管理员
     * @param roleIds
     * @return
     */
    List<AdminDto> findAdminByRoleIds(List<Long> roleIds);

    /**
     * 根据邮箱获取管理员信息
     * @param email
     * @return
     */
    AdminDto findByEmail(String email);

    /**
     * 根据姓名或者账号拼音去匹配员工列表
     * @param adminName
     * @return
     */
    List<AdminDto> findByNameLike(String adminName);

}
