package cn.com.duiba.sso.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sso.api.domain.dto.SystemDto;

import java.util.Set;

/**
 * Created by liuyao on 2017/12/5.
 */
@SsoInterface(RemoteSystemService.class)
@AdvancedFeignClient
public interface RemoteSystemService {

    /**
     * 根据系统别名获取系统信息
     * @param appNameAlias
     * @return
     */
    SystemDto getSystemByAlias(String appNameAlias);

    /**
     * 提交版本号
     */
    void submitSsoVersion(Long systemId,String version);

    /**
     * 获取系统的版本号
     * @param systemId
     * @return
     */
    String getSystemVersion(Long systemId);

    /**
     *
     * 获取需要在网关层进行权限校验的
     * @return
     */
    Set<String> getZuulSystemAliasCollection();
}
