package cn.com.duiba.sso.ui.mume;

import cn.com.duiba.sso.ui.SsoUIProperties;
import com.alibaba.fastjson.JSONArray;
import com.google.common.io.CharSource;
import com.google.common.io.Files;
import org.apache.commons.io.Charsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ResourceUtils;

import javax.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class FileMumeLoader implements MumeLoader {

    private volatile List<SsoUIMume> mumes = Collections.emptyList();

    @Autowired
    private SsoUIProperties ssoUIProperties;


    @PostConstruct
    public void init() throws IOException {
        File resource= ResourceUtils.getFile(ssoUIProperties.getMenuResource());
        CharSource charSource = Files.asCharSource(resource, Charsets.UTF_8);
        String context = charSource.read();
        mumes = JSONArray.parseArray(context,SsoUIMume.class);
    }

    @Override
    public List<SsoUIMume> loadUIMume() {
        return mumes;
    }
}
