package cn.com.duiba.sso.ui.resource;

import cn.com.duiba.sso.api.tool.TemplateUtils;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import static org.springframework.web.bind.annotation.RequestMethod.GET;

@Service
public class SsoUIResManager {

    @Value("classpath:temp/main.jsvm")
    Resource mainJs;


    private Map<String,String> jsMap = Maps.newConcurrentMap();

    private String webTitle = "服务综合治理平台";

    public void regestModule(String name,String configuration){
        jsMap.put(name,configuration);
    }

    public void setWebTitle(String webTitle) {
        this.webTitle = webTitle;
    }

    protected String getWebTitle() {
        return webTitle;
    }

    protected String getMainJs() throws IOException {
        List<String> list = Lists.newArrayList();
        list.addAll(jsMap.keySet());
        String lists = JSONObject.toJSONString(list);
        String maps =  JSONObject.toJSONString(jsMap);

        JSONObject model = new JSONObject();
        model.put("rootMoudles",lists);
        model.put("rootMoudleMap",maps);

        CharSource source = Resources.asCharSource(mainJs.getURL(), Charsets.UTF_8);
        return TemplateUtils.replaceArgs(source.read(),model);
    }



}
