/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.ui.resource;

import cn.com.duiba.sso.api.remoteservice.RemoteSystemService;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import cn.com.duiba.sso.ui.mume.MumeLoader;
import cn.com.duiba.sso.ui.mume.SsoUIMume;
import cn.com.duiba.sso.ui.resource.SsoUIResManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SsoUIController {
    private Logger logger = LoggerFactory.getLogger(SsoUIController.class);
    @Autowired
    private MumeLoader mumeLoader;
    @Autowired
    private SsoUIResManager ssoUIResManager;
    @Autowired
    private RemoteSystemService remoteSystemService;
    @Value(value="classpath:ui/index.html")
    Resource indexHtml;

    @CanAccess
    @ResponseBody
    @RequestMapping(value={"/sso/ui/uiMume"}, method={RequestMethod.GET})
    public JsonRender uiMume() {
        try {
            List<SsoUIMume> ssoUIMume = this.mumeLoader.loadUIMume();
            this.fixMumeUrl(ssoUIMume);
            JsonRender render = JsonRender.successResult();
            render.put("mumes", ssoUIMume);
            render.put("webTitle", (Object)this.ssoUIResManager.getWebTitle());
            return render;
        }
        catch (Exception e) {
            return JsonRender.failResult((Throwable)e);
        }
    }

    @AuthCanAccess
    @RequestMapping(value={"/ui/index.html"}, method={RequestMethod.GET})
    public ResponseEntity serveIndex() {
        ResponseEntity.BodyBuilder result = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)1L, (TimeUnit)TimeUnit.MINUTES))).contentType(MediaType.TEXT_HTML);
        return result.body((Object)this.indexHtml);
    }

    @AuthCanAccess
    @RequestMapping(value={"/ui/", "/ui"}, method={RequestMethod.GET})
    public ModelAndView forwardUiEndpoints() {
        return new ModelAndView("forward:/ui/index.html");
    }

    @AuthCanAccess
    @RequestMapping(value={"/ui/main.js"}, method={RequestMethod.GET})
    public ResponseEntity mainJs() throws IOException {
        ResponseEntity.BodyBuilder result = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)1L, (TimeUnit)TimeUnit.MINUTES))).contentType(MediaType.parseMediaType((String)"application/javascript"));
        return result.body((Object)this.ssoUIResManager.getMainJs());
    }

    private void fixMumeUrl(List<SsoUIMume> ssoUIMumes) {
        List<SsoUIMume> mumes = this.traversal(ssoUIMumes);
        HashSet appNames = Sets.newHashSet();
        ArrayList canFixList = Lists.newArrayList();
        for (SsoUIMume mume : mumes) {
            if (!StringUtils.isNotBlank((String)mume.getSystem()) || !StringUtils.equals((String)SystemInfo.getSystemAlias(), (String)mume.getSystem())) continue;
            appNames.add(mume.getSystem());
            canFixList.add(mume);
        }
        Map homeUrlMap = this.remoteSystemService.findAppHomeUrlMap(SystemInfo.getProfiles(), (Set)appNames);
        for (SsoUIMume mume : canFixList) {
            try {
                if (!homeUrlMap.containsKey(mume.getSystem())) continue;
                String homeUrl = (String)homeUrlMap.get(mume.getSystem());
                if (StringUtils.startsWith((String)mume.getUrl(), (String)"/")) {
                    mume.setUrl(homeUrl + mume.getUrl());
                }
                if (!StringUtils.startsWith((String)mume.getUrl(), (String)"http")) continue;
                String url = mume.getUrl();
                URL url1 = new URL(homeUrl);
                URL url2 = new URL(mume.getUrl());
                url = url.replace(url2.getHost(), url1.getHost());
                mume.setUrl(url);
            }
            catch (Exception e) {
                this.logger.debug("url:" + mume.getUrl() + "\u89e3\u6790\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private List<SsoUIMume> traversal(List<SsoUIMume> ssoUIMumes) {
        ArrayList returnList = Lists.newArrayList();
        for (SsoUIMume mume : ssoUIMumes) {
            returnList.add(mume);
            if (mume.getChild() == null || mume.getChild().isEmpty()) continue;
            returnList.addAll(this.traversal(mume.getChild()));
        }
        return returnList;
    }
}

