/**
 * ui.model.ext 是构建在 ui.bootstrap.model之上的封装
 * 详见 http://angular-ui.github.io/bootstrap/#!#modal
 */
define([
    "angular",
    "/ui/lib/bootstrap/ui-bootstrap-tpls-0.14.3.min.js",
    "/ui/directive/model/angular-toastr-1.4.1.tpls.js",

    "css!./ui-model.css"
],function (angular) {

    const model = angular.module("ui.model", ["ui.bootstrap","toastr"]);
    model.run(Run);
    model.service("UiModel",UiModel);

    /** @ngInject **/
    function Run($templateRequest){
        //预加载消息html模板
        $templateRequest("/ui/directive/model/loading.html");
        $templateRequest("/ui/directive/model/prompt.html");
    }

    /** @ngInject **/
    function UiModel($uibModal,$rootScope,toastr){

        /**
         * 消息提示
         * @param message 信息
         * @param title 标题
         * @param config 标题
         * @returns promise
         */
        function alert(message,title,config){
            return confirm(message,title,angular.extend({},config,{showCancel:false}));
        }

        /**
         * 消息确认
         * @param message
         * @param title
         * @param config
         * {showCancel:true}
         * @returns promise
         */
        function confirm(message,title,config) {
            return prompt(message,title,angular.extend({showInput:false},config))
        }

        /**
         * 带输入框的消息确认
         * @param message
         * @param title
         * @param config default @see DEFAULT_PROMPT_CONFIG
         * @returns promise
         */
        function prompt(message,title,config){
            title = !!title?title:"提示";
            config = !!config?config:{};
            const promptInstance = $uibModal.open({
                size:!!config.size?config.size:"sm",
                animation: true,
                templateUrl:'/ui/directive/model/prompt.html',
                controller: PromptController,
                backdrop:'static',
                windowClass:"uiPrompt",
                resolve:{
                    $promptConfig:function(){
                        return angular.extend({},DEFAULT_PROMPT_CONFIG,config,{message:message,title:title});
                    }
                }
            });
            return promptInstance.result;
        }

        function message(message,type,timeout){

            type = !!type?type:"success";
            type = type!=="danger"?type:"error";

            const messageConfig = {};
            !!timeout && (messageConfig.timeOut = timeout);
            toastr[type](message,"",messageConfig);
        }

        function loading(message){
            const LOADING_SCOPE = $rootScope.$new();
            LOADING_SCOPE.message = message;
            const instance = $uibModal.open({
                size:"sm",
                animation: true,
                templateUrl:'/ui/directive/model/loading.html',
                backdrop:'static',
                windowClass:"uiLoading",
                scope:LOADING_SCOPE
            });
            return new LoadingController(LOADING_SCOPE,instance);
        }

        var model = {
            alert:alert,
            confirm:confirm,
            prompt:prompt,
            loading:loading,
            message:message
        };

        angular.extend(model,toastr);
        return model;
    }

    function LoadingController(scope,instance){
        this.scope = scope;
        this.instance = instance;
    }

    LoadingController.prototype.updateMessage=function(message){
        this.scope.message = message;
        this.scope.$digest();
    };

    LoadingController.prototype.close=function(){
        this.instance.close();
    };


    const DEFAULT_PROMPT_CONFIG = {
        message:"",
        title:"",
        showCancel:true,
        showInput:true,
        promptInputInit:"",
        promptPlaceholder:"",
        type:"prompt",

        submitBtn:"确认",
        submitBtnClass:'primary',
        cancelBtn:"取消"
    };

    /** @ngInject **/
    function PromptController($promptConfig,$scope,$uibModalInstance){

        $scope.input = $promptConfig.promptInputInit;

        $scope.$promptConfig = $promptConfig;

        $scope.submit = function(){
            const input = $promptConfig.showInput?$scope.input:undefined;
            $uibModalInstance.close(input);
        };
        $scope.cancel = function(){
            $promptConfig.showCancel && $uibModalInstance.dismiss();
        }
    }



    return model;
});


