/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.ui.resource;

import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.remoteservice.RemoteSystemService;
import cn.com.duiba.sso.api.service.system.EnvironmentDecisionMaker;
import cn.com.duiba.sso.api.service.system.EnvironmentEnum;
import cn.com.duiba.sso.api.tool.TemplateUtils;
import cn.com.duiba.sso.ui.mume.MumeLoader;
import cn.com.duiba.sso.ui.mume.SsoUIMume;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SsoUIResManager {
    private static final Logger log = LoggerFactory.getLogger(SsoUIResManager.class);
    @Value(value="classpath:temp/main.jsvm")
    private org.springframework.core.io.Resource mainJs;
    @Value(value="classpath:temp/index.html")
    private org.springframework.core.io.Resource mainHomeIndex;
    @Resource
    private SsoProperties ssoProperties;
    @Resource
    private MumeLoader mumeLoader;
    @Resource
    private EnvironmentDecisionMaker environmentDecisionMaker;
    @Resource
    private RemoteSystemService remoteSystemService;
    private Map<String, String> jsMap = Maps.newConcurrentMap();
    private String webTitle = "\u670d\u52a1\u7efc\u5408\u6cbb\u7406\u5e73\u53f0";

    public void regestModule(String name, String configuration) {
        this.jsMap.put(name, configuration);
    }

    public void setWebTitle(String webTitle) {
        this.webTitle = webTitle;
    }

    protected String indexHtml() throws IOException {
        JSONObject model = new JSONObject();
        model.put("rootPath", (Object)this.ssoProperties.getRootPath());
        model.put("webTitle", (Object)this.webTitle);
        EnvironmentEnum environmentEnum = this.environmentDecisionMaker.getEnvironmentEnum();
        model.put("environment", (Object)environmentEnum.getName());
        List<SsoUIMume> ssoUIMume = this.mumeLoader.loadUIMume();
        this.fixMumeUrl(ssoUIMume);
        model.put("mumeList", (Object)JSONArray.toJSONString(ssoUIMume));
        CharSource source = Resources.asCharSource((URL)this.mainHomeIndex.getURL(), (Charset)Charsets.UTF_8);
        return TemplateUtils.replaceArgs((String)source.read(), (JSONObject)model);
    }

    protected String getMainJs() throws IOException {
        ArrayList list = Lists.newArrayList();
        list.addAll(this.jsMap.keySet());
        String lists = JSONObject.toJSONString((Object)list);
        String maps = JSONObject.toJSONString(this.jsMap);
        JSONObject model = new JSONObject();
        model.put("rootMoudles", (Object)lists);
        model.put("rootMoudleMap", (Object)maps);
        CharSource source = Resources.asCharSource((URL)this.mainJs.getURL(), (Charset)Charsets.UTF_8);
        return TemplateUtils.replaceArgs((String)source.read(), (JSONObject)model);
    }

    private void fixMumeUrl(List<SsoUIMume> ssoUIMumes) {
        List<SsoUIMume> mumes = this.traversal(ssoUIMumes);
        HashSet appNames = Sets.newHashSet();
        ArrayList canFixList = Lists.newArrayList();
        for (SsoUIMume mume : mumes) {
            if (!StringUtils.isNotBlank((String)mume.getSystem())) continue;
            appNames.add(mume.getSystem());
            canFixList.add(mume);
        }
        EnvironmentEnum environmentEnum = this.environmentDecisionMaker.getEnvironmentEnum();
        Map homeUrlMap = this.remoteSystemService.findAppHomeUrlMap(environmentEnum.getName(), (Set)appNames);
        for (SsoUIMume mume : canFixList) {
            try {
                if (!homeUrlMap.containsKey(mume.getSystem())) continue;
                String homeUrl = (String)homeUrlMap.get(mume.getSystem());
                if (StringUtils.startsWith((String)mume.getUrl(), (String)"/")) {
                    mume.setUrl(homeUrl + mume.getUrl());
                }
                if (!StringUtils.startsWith((String)mume.getUrl(), (String)"http")) continue;
                String url = mume.getUrl();
                URL url1 = new URL(homeUrl);
                URL url2 = new URL(mume.getUrl());
                url = url.replace(url2.getAuthority(), url1.getAuthority());
                mume.setUrl(url);
            }
            catch (Exception e) {
                log.debug("url:" + mume.getUrl() + "\u89e3\u6790\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private List<SsoUIMume> traversal(List<SsoUIMume> ssoUIMumes) {
        ArrayList returnList = Lists.newArrayList();
        for (SsoUIMume mume : ssoUIMumes) {
            returnList.add(mume);
            if (mume.getChild() == null || mume.getChild().isEmpty()) continue;
            returnList.addAll(this.traversal(mume.getChild()));
        }
        return returnList;
    }
}

