/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.ui.resource;

import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.service.HostEnvironmentMapping;
import cn.com.duiba.sso.api.service.SsoUrlService;
import cn.com.duiba.sso.api.service.system.EnvironmentDecisionMaker;
import cn.com.duiba.sso.api.service.system.EnvironmentEnum;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import cn.com.duiba.sso.ui.resource.SsoUIResManager;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.CacheControl;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SsoUIController {
    @Autowired
    private SsoUIResManager ssoUIResManager;
    @Autowired
    private EnvironmentDecisionMaker environmentDecisionMaker;
    @Autowired
    private SsoUrlService ssoUrlService;
    @Autowired
    private HostEnvironmentMapping hostEnvironmentMapping;

    @CanAccess
    @ResponseBody
    @RequestMapping(value={"${duiba.sso.root-path:'/sso'}/ui/systemInfo"})
    public JsonRender systemInfo() {
        JsonRender render = JsonRender.successResult();
        render.put("ssoHomeURL", (Object)this.ssoUrlService.getSsoHomeUrl());
        SystemDto systemDto = SystemInfo.getThisSystemInfo();
        render.put("system", (Object)systemDto);
        render.put("environment", (Object)this.environmentDecisionMaker.getEnvironmentEnum().getName());
        List hostEnvironments = this.hostEnvironmentMapping.getHostEnvironmentMappings();
        List environments = hostEnvironments.stream().map(item -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("host", (Object)item.getHost());
            EnvironmentEnum environment = item.getEnvironment();
            jsonObject.put("environment", (Object)environment.getName());
            jsonObject.put("environmentName", (Object)environment.getEnvName());
            return jsonObject;
        }).collect(Collectors.toList());
        render.put("hostEnvironmentMapping", environments);
        return render;
    }

    @AuthCanAccess
    @RequestMapping(value={"/ui/index.html"}, method={RequestMethod.GET})
    public ResponseEntity serveIndex() throws IOException {
        ResponseEntity.BodyBuilder result = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)1L, (TimeUnit)TimeUnit.MINUTES))).contentType(MediaType.TEXT_HTML);
        return result.body((Object)this.ssoUIResManager.indexHtml());
    }

    @AuthCanAccess
    @RequestMapping(value={"/ui", "${duiba.sso.root-path:'/sso'}/", "${duiba.sso.root-path:'/sso'}"}, method={RequestMethod.GET})
    public ModelAndView forwardUiEndpoints() {
        return new ModelAndView("forward:/ui/index.html");
    }

    @AuthCanAccess
    @RequestMapping(value={"${duiba.sso.root-path:'/sso'}/ui/main.js"}, method={RequestMethod.GET})
    public ResponseEntity mainJs() throws IOException {
        ResponseEntity.BodyBuilder result = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)1L, (TimeUnit)TimeUnit.MINUTES))).contentType(MediaType.parseMediaType((String)"application/javascript"));
        return result.body((Object)this.ssoUIResManager.getMainJs());
    }
}

