/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.ui.resource;

import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import cn.com.duiba.application.boot.api.domain.enums.AdminApplicationRelation;
import cn.com.duiba.application.boot.api.remoteservice.RemoteApplicationPermissionService;
import cn.com.duiba.application.boot.api.remoteservice.RemoteApplicationService;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${duiba.sso.root-path:'/sso'}/uiboot"})
public class UiBootDataController {
    @Resource
    private RemoteApplicationService remoteApplicationService;
    @Resource
    private RemoteApplicationPermissionService remoteApplicationPermissionService;

    @AuthCanAccess
    @GetMapping(value={"/findAllApplication"})
    public JsonRender findAllApplication() {
        List apps = this.remoteApplicationService.findAllApplication();
        JsonRender model = JsonRender.successResult();
        JSONArray applications = new JSONArray();
        for (ApplicationDto system : apps) {
            JSONObject app = new JSONObject();
            app.put("alias", (Object)system.getAppAlias());
            app.put("name", (Object)system.getAppName());
            app.put("id", (Object)system.getId());
            applications.add((Object)app);
        }
        model.put("applications", (Object)applications);
        return model;
    }

    @AuthCanAccess
    @GetMapping(value={"/findConcernApplications"})
    public JsonRender findConcernApplications() {
        Set applications = this.remoteApplicationPermissionService.findAppAliasByAdminAndRelation(RequestTool.getAdminId(), AdminApplicationRelation.CONCERN);
        JsonRender model = JsonRender.successResult();
        model.put("applications", (Object)applications);
        return model;
    }
}

