/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.ui.mume;

import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import cn.com.duiba.sso.api.domain.dto.PowerDto;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.service.SsoApplicationService;
import cn.com.duiba.sso.api.service.power.PowerTreeCache;
import cn.com.duiba.sso.api.service.power.PowerTreeService;
import cn.com.duiba.sso.ui.SsoUIProperties;
import cn.com.duiba.sso.ui.mume.MumeLoader;
import cn.com.duiba.sso.ui.mume.SsoUIMume;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;

public class SystemResourceMumeLoader
implements MumeLoader {
    private static final String UI_SYSTEM_NAME = "zt-ui-boot";
    @Resource
    private PowerTreeService powerTreeService;
    @Resource
    private SsoApplicationService ssoSystemService;
    @Resource
    private SsoUIProperties ssoUIProperties;

    @Override
    public List<SsoUIMume> loadUIMume() {
        String systemName = Optional.ofNullable(this.ssoUIProperties.getMenuResource()).orElse(UI_SYSTEM_NAME);
        ApplicationDto system = this.ssoSystemService.getSystemByAlias(systemName);
        PowerTreeCache cache = this.powerTreeService.getPowerTreeCache(system.getId());
        SsoUIMumeTransform transform = new SsoUIMumeTransform();
        transform.setCache(cache);
        return cache.getPowerTree((Function)transform);
    }

    private class SsoUIMumeTransform
    implements Function<PowerDto, SsoUIMume> {
        private PowerTreeCache cache;
        private Joiner joiner = Joiner.on((String)".").skipNulls();

        private SsoUIMumeTransform() {
        }

        @Override
        public SsoUIMume apply(PowerDto powerDto) {
            if (StringUtils.isBlank((String)powerDto.getJson())) {
                throw new SsoRunTimeException("\u83dc\u5355\u9879\uff1a" + powerDto.getName() + "\u914d\u7f6e\u5f02\u5e38");
            }
            SsoUIMume mume = new SsoUIMume();
            mume.setId(powerDto.getId());
            mume.setParentId(powerDto.getParentId());
            mume.setName(powerDto.getName());
            mume.setWeight(powerDto.getWeight());
            JSONObject json = JSONObject.parseObject((String)powerDto.getJson());
            List powerLinks = this.cache.getPowerWay(powerDto.getId());
            List stateList = powerLinks.stream().map(power -> {
                JSONObject item = JSONObject.parseObject((String)power.getJson());
                return item.getString("state");
            }).collect(Collectors.toList());
            mume.setUrl(json.getString("url"));
            mume.setState(this.joiner.join(stateList));
            if (json.containsKey((Object)"params")) {
                mume.setParams(json.getJSONObject("params"));
            }
            if (json.containsKey((Object)"icon")) {
                mume.setIcon(json.getString("icon"));
            }
            if (json.containsKey((Object)"system")) {
                mume.setSystem(json.getString("system"));
            }
            if (json.containsKey((Object)"keys")) {
                mume.setSsoRes(json.getString("keys"));
            }
            return mume;
        }

        public PowerTreeCache getCache() {
            return this.cache;
        }

        public void setCache(PowerTreeCache cache) {
            this.cache = cache;
        }
    }
}

