define(["angular"],function(angular){
    Array.prototype.each=function(fun){
        angular.forEach(this,function(v,k){
            fun( v, k);
        });
    };
    Array.prototype.clone=function(){
        const o=[];
        this.each(function(v,k){
            o[k]=v;
        });
        return o;
    };
    Array.prototype.uniqWith=function(equalsFunction){
        if(!!equalsFunction && !angular.isFunction(equalsFunction)){
            throw "uniqWith的参数必须是函数"
        }
        const result = [];
        this.each(function(v){
            if(result.length===0){
                result.push(v);
                return;
            }
            let flag = true;
            result.each(function (item) {
                 !!equalsFunction(item, v) && (flag = false);
            });
            flag && result.push(v);
        });
        return result;
    };
    Array.prototype.unique=function(){
        return this.uniqWith(angular.equals);
    };
    Array.prototype.filter=function(predicate){
        const result = [];
        this.each(function(v){
            if(predicate(v)){
                result.push(v);
            }
        });
        return result;
    };

    /**
     * 根据决定表达式，找出最小的项
     * @param transfrom
     * @returns {*}
     */
    Array.prototype.minBy=function(transfrom){
        if(this.length===0){
            return null;
        }
        const sort = [];
        const map = {};

        this.each(function(v){
            const key = transfrom(v);
            sort.push(key);
            map[key] = v;
        });
        sort.sort(NumAscSort);
        return map[sort[0]];
    };

    /**
     * 根据决定表达式找出最大的项
     * @param transform
     * @returns {*}
     */
    Array.prototype.maxBy=function(transform){
        if(this.length===0){
            return null;
        }
        const sort = [];
        const map = {};

        this.each(function(v){
            const key = transform(v);
            sort.push(key);
            map[key] = v;
        });
        sort.sort(NumDascSort);
        return map[sort[0]];
    };

    /**
     * 根据迭代项的分组依据表达式进行分组
     * @param keyFunction
     * @returns {MultiMap}
     */
    Array.prototype.groupBy=function(keyFunction){
        const multiMap = new MultiMap();
        this.each(function(item){
            multiMap.put(keyFunction(item),item);
        });
        return multiMap;
    };

    /**
     * 升序
     * @return {number}
     */
    function NumAscSort(a,b){
        return a - b;
    }

    /**
     * 降序
     * @return {number}
     */
    function NumDascSort(a,b){
        return b - a;
    }


    /**
     * 一个key对应多个值的Map
     * @constructor
     */
    function MultiMap() {
        this.data = {};
    }

    MultiMap.prototype.put = function(key,value){
        if(!this.containsKey(key)){
            this.initKey(key)
        }
        this.data[key].push(value);
    };

    MultiMap.prototype.get = function (key) {
        if(this.containsKey(key)){
            return this.data[key];
        }else{
            return [];
        }
    };

    MultiMap.prototype.keySet = function () {
        const kets = [];
        angular.forEach(this.data,function (value,key) {
            kets.push(key);
        });
        return kets;
    };

    MultiMap.prototype.count = function (key) {
        return this.data[key].length;
    };

    MultiMap.prototype.containsKey = function (key) {
        return !!this.data[key];
    };

    MultiMap.prototype.initKey = function (key) {
        this.data[key] = [];
    };

    window.MultiMap = MultiMap;

});


