package cn.com.duiba.sso.ui.mume;

import cn.com.duiba.sso.ui.SsoUIProperties;
import com.alibaba.fastjson.JSONArray;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import org.apache.commons.io.Charsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

import javax.annotation.PostConstruct;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;

public class FileMumeLoader implements MumeLoader {

    private volatile List<SsoUIMume> mumes = Collections.emptyList();

    @Autowired
    private SsoUIProperties ssoUIProperties;
    @Autowired
    private ApplicationContext applicationContext;

    @PostConstruct
    public void init() throws IOException {
        Resource resource = applicationContext.getResource(ssoUIProperties.getMenuResource());
        if(!resource.exists()){
            String message = "路径："+ssoUIProperties.getMenuResource()+"对应的文件不存在";
            throw new IOException(message);
        }
        CharSource charSource = Resources.asCharSource(resource.getURL(), StandardCharsets.UTF_8);
        String context = charSource.read();
        mumes = JSONArray.parseArray(context,SsoUIMume.class);
    }

    @Override
    public List<SsoUIMume> loadUIMume() {
        return mumes;
    }
}
