define([
    "angular",
    "/ui/directive/time/moment.js",
    "/ui/lib/bootstrap/ui-bootstrap-tpls-0.14.3.min.js",
    "/ui/directive/select/select.min.js",
    "/ui/directive/model/ui-model.js",
    "/ui/directive/jqueryui/jquery-ui-configuration.js",
    "/ui/directive/file/ui-file-configuration.js",
    "/ui/directive/tree/angular-tree-control.js",
    "/ui/directive/time/angular-moment-picker.min.js",

    "css!/ui/directive/select/select.min.css"
],function (angular,moment) {

    const directive = angular.module("ui.directive.ext",[
        "ui.bootstrap","ui.select","ui.model","jquery.ui","ui.file","treeControl","moment-picker"
    ]);

    directive.value("moment",moment);
    directive.directive('openSwitch',OpenSwitch);
    directive.directive('ngSelect', NgSelect);
    directive.directive('progressList', ProgressList);
    directive.controller('SelectController',SelectController);
    directive.controller('ProgressListController',ProgressListController);
    directive.directive('ngRightClick', function($parse) {
        return {
            restrict: 'A',
            link:function(scope, element, attrs) {
                var fn = $parse(attrs.ngRightClick);
                element.bind('contextmenu', function(event) {
                    scope.$apply(function() {
                        event.preventDefault();
                        fn(scope, {$event:event});
                    });
                });
            }
        }
    });

    function OpenSwitch() {
        return {
            priority: 0,
            // terminal: true,
            scope: {
                ngModel:"="

            }, // {} = isolate, true = child, false/undefined = no change
            controllerAs: 'Switch',
            restrict: 'EA', // E = Element, A = Attribute, C = Class, M = Comment
            template: "<div class='open-switch'><span class='open-button'></span></div>",
            replace: true,
            // compile: function(tElement, tAttrs, function transclude(function(scope, cloneLinkingFn){ return function linking(scope, elm, attrs){}})),
            link: function ($scope, iElm, iAttrs, controller) {

            }
        };
    }

    function NgSelect(){
        return {
            priority: 0,
            templateUrl: "/ui/directive/select/select.html",
            scope: {
                key:"@",
                labelName:"@",
                name:"@",
                value:"=",
                options:"=",
                ngDisabled:"="
            },
            controller:"SelectController",
            controllerAs:'select',
            restrict: 'E', // E = Element, A = Attribute, C = Class, M = Comment
            replace: true,
            link:function($scope, iElm, iAttrs, controller) {
                controller.required = iAttrs.required;
            }
        }
    }

    function ProgressList(){
        return {
            priority: 0,
            templateUrl: "/ui/directive/progress/progress.html",
            scope: {
                progressConfig:"=",
                progressIndex:"=",
                progressResult:"="
            },
            controller:"ProgressListController",
            controllerAs:'progress',
            restrict: 'E', // E = Element, A = Attribute, C = Class, M = Comment
            replace: true,
            link: function($scope, iElm, iAttrs, controller) {

                var config = $scope.progressConfig;
                controller.configList= [];
                angular.forEach(config,function(item){
                    var newConfig = {};
                    newConfig.key = item.key;
                    newConfig.name = item.name;
                    item.result = 0;
                    controller.configList.push(newConfig);
                });
            }
        }
    }

    SelectController.$inject = ["$scope"];
    function SelectController($scope){

        var select = this;
        select.open=false;

        select.selectOption = selectOption;
        select.isSelect = isSelect;
        select.getLabel = getLabel;

        function selectOption(index){
            select.open=false;
            var option = $scope.options[index];
            $scope.value = option[$scope.key];
        }

        function isSelect(index){
            return $scope.options[index][$scope.key]===$scope.value;
        }

        function getLabel(){
            var name = "请选择";
            angular.forEach($scope.options,function(option,index){
                if(isSelect(index)){
                    name = option[$scope.labelName];
                }
            });
            return name;
        }

    }

    ProgressListController.$inject = ["$scope"];
    function ProgressListController($scope){

        var progress = this;

        progress.configList = [];

        $scope.$watch("progressIndex",function (newKey) {
            var isCurrayIndex = true;
            angular.forEach(progress.configList,function(config){

                if(newKey!==config.key){
                    config.result = isCurrayIndex?1:0;
                }else{
                    config.result = 0;
                    isCurrayIndex = false;
                }
            })
        });
        $scope.$watch("progressResult",function (result) {
            var isCurrayIndex = true;
            angular.forEach(progress.configList,function(config){
                if($scope.progressIndex===config.key){
                    config.result = result;
                }
            })
        });
    }

    directive.filter('propsFilter', function() {
        return function(items, props) {
            var out = [];

            if (angular.isArray(items)) {
                var keys = Object.keys(props);

                items.forEach(function(item) {
                    var itemMatches = false;

                    for (var i = 0; i < keys.length; i++) {
                        var prop = keys[i];
                        var text = props[prop].toLowerCase();
                        if (item[prop].toString().toLowerCase().indexOf(text) !== -1) {
                            itemMatches = true;
                            break;
                        }
                    }

                    if (itemMatches) {
                        out.push(item);
                    }
                });
            } else {
                // Let the output be the input untouched
                out = items;
            }

            return out;
        };
    });


    return directive;
});