/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.ui.resource;

import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.component.environment.EnvironmentService;
import cn.com.duiba.application.boot.api.component.environment.RequestEnvironmentDecisionMaker;
import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import cn.com.duiba.application.boot.api.domain.dto.Cluster;
import cn.com.duiba.application.boot.api.remoteservice.RemoteClusterService;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.service.HostEnvironment;
import cn.com.duiba.sso.api.service.HostEnvironmentMapping;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import cn.com.duiba.sso.ui.SsoUIProperties;
import cn.com.duiba.sso.ui.resource.SsoUIResManager;
import com.alibaba.fastjson.JSONObject;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.CacheControl;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SsoUIController {
    @Resource
    private SsoUIResManager ssoUIResManager;
    @Resource
    private RequestEnvironmentDecisionMaker requestEnvironmentDecisionMaker;
    @Resource
    private HostEnvironmentMapping hostEnvironmentMapping;
    @Resource
    private RemoteSSOService remoteSSOService;
    @Resource
    private EnvironmentService environmentService;
    @Resource
    private RemoteClusterService remoteClusterService;
    @Resource
    private SsoUIProperties ssoUIProperties;
    private final LoadingCache<HostEnvironment, Cluster> clusterCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<HostEnvironment, Cluster>(){

        @Nullable
        public Cluster load(@Nonnull HostEnvironment hostEnvironment) {
            Environment environment = hostEnvironment.getEnvironment();
            return SsoUIController.this.remoteClusterService.findCluster(environment.getId(), hostEnvironment.getCluster());
        }
    });

    @CanAccess
    @ResponseBody
    @RequestMapping(value={"${duiba.sso.root-path:'/sso'}/ui/systemInfo"})
    public JsonRender systemInfo() {
        JsonRender render = JsonRender.successResult();
        render.put("ssoHomeURL", (Object)this.remoteSSOService.findSsoHomeUrl());
        ApplicationDto systemDto = SystemInfo.getThisSystemInfo();
        render.put("system", (Object)systemDto);
        Environment currentEnvironment = this.requestEnvironmentDecisionMaker.getRequestEnvironment();
        List hostEnvironments = this.hostEnvironmentMapping.getHostEnvironmentMappings();
        String clusterKey = this.environmentService.currentClusterKey();
        List environments = hostEnvironments.stream().map(item -> {
            Cluster cluster = (Cluster)this.clusterCache.get(item);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("host", (Object)item.getHost());
            Environment environment = item.getEnvironment();
            jsonObject.put("clusterName", (Object)Optional.ofNullable(cluster).map(Cluster::getName).orElse("\u672a\u77e5"));
            jsonObject.put("currentCluster", (Object)(environment == currentEnvironment && StringUtils.equals((String)clusterKey, (String)item.getCluster()) ? 1 : 0));
            return jsonObject;
        }).collect(Collectors.toList());
        render.put("hostEnvironmentMapping", environments);
        return render;
    }

    @AuthCanAccess
    @RequestMapping(value={"/ui/index.html"}, method={RequestMethod.GET})
    public ResponseEntity serveIndex() throws IOException {
        ResponseEntity.BodyBuilder result = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)1L, (TimeUnit)TimeUnit.MINUTES))).contentType(MediaType.TEXT_HTML);
        return result.body((Object)this.ssoUIResManager.indexHtml());
    }

    @AuthCanAccess
    @RequestMapping(value={"/ui", "${duiba.sso.root-path:'/sso'}/", "${duiba.sso.root-path:'/sso'}"}, method={RequestMethod.GET})
    public ModelAndView forwardUiEndpoints() {
        return new ModelAndView("forward:" + this.ssoUIProperties.getIndexFilePath());
    }

    @AuthCanAccess
    @RequestMapping(value={"${duiba.sso.root-path:'/sso'}/ui/{version}/main.js"}, method={RequestMethod.GET})
    public ResponseEntity mainJs() throws IOException {
        ResponseEntity.BodyBuilder result = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Cache-Control", new String[]{"no-cache,no-store"})).contentType(MediaType.parseMediaType((String)"application/javascript"));
        return result.body((Object)this.ssoUIResManager.getMainJs());
    }
}

