/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.ui.resource;

import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.component.environment.EnvironmentService;
import cn.com.duiba.application.boot.api.component.environment.RequestEnvironmentDecisionMaker;
import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.tool.TemplateUtils;
import cn.com.duiba.sso.ui.mume.MumeLoader;
import cn.com.duiba.sso.ui.mume.SsoUIMume;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SsoUIResManager {
    private static final Logger log = LoggerFactory.getLogger(SsoUIResManager.class);
    @Value(value="classpath:temp/main.js")
    private org.springframework.core.io.Resource mainJs;
    @Value(value="classpath:temp/index.html")
    private org.springframework.core.io.Resource mainHomeIndex;
    @Value(value="${ui.version:0.0.1}")
    private String uiVersion;
    @Resource
    private SsoProperties ssoProperties;
    @Resource
    private MumeLoader mumeLoader;
    @Resource
    private RequestEnvironmentDecisionMaker requestEnvironmentDecisionMaker;
    @Resource
    private EnvironmentService environmentService;
    private Map<String, String> jsMap = Maps.newConcurrentMap();
    private String webTitle = "\u670d\u52a1\u7efc\u5408\u6cbb\u7406\u5e73\u53f0";
    private String licenseKey;

    public void regestModule(String name, String configuration) {
        this.jsMap.put(name, configuration);
    }

    public void setWebTitle(String webTitle) {
        this.webTitle = webTitle;
    }

    public void setLicenseKey(String licenseKey) {
        this.licenseKey = licenseKey;
    }

    protected String indexHtml() throws IOException {
        JSONObject model = new JSONObject();
        model.put("rootPath", (Object)this.ssoProperties.getRootPath());
        model.put("webTitle", (Object)this.webTitle);
        Environment Environment2 = this.requestEnvironmentDecisionMaker.getRequestEnvironment();
        model.put("environment", (Object)Environment2.getEnvId());
        model.put("cluster", (Object)this.environmentService.currentClusterKey());
        model.put("uiVersion", (Object)this.uiVersion);
        model.put("licenseKey", (Object)this.licenseKey);
        List<SsoUIMume> ssoUIMume = this.mumeLoader.loadUIMume();
        model.put("mumeList", (Object)JSONArray.toJSONString(ssoUIMume));
        CharSource source = Resources.asCharSource((URL)this.mainHomeIndex.getURL(), (Charset)Charsets.UTF_8);
        return TemplateUtils.replaceArgs((String)source.read(), (JSONObject)model);
    }

    protected String getMainJs() throws IOException {
        ArrayList list = Lists.newArrayList();
        list.addAll(this.jsMap.keySet());
        String lists = JSONObject.toJSONString((Object)list);
        String maps = JSONObject.toJSONString(this.jsMap);
        JSONObject model = new JSONObject();
        model.put("rootMoudles", (Object)lists);
        model.put("rootMoudleMap", (Object)maps);
        model.put("uiVersion", (Object)this.uiVersion);
        CharSource source = Resources.asCharSource((URL)this.mainJs.getURL(), (Charset)Charsets.UTF_8);
        return TemplateUtils.replaceArgs((String)source.read(), (JSONObject)model);
    }

    private List<SsoUIMume> traversal(List<SsoUIMume> ssoUIMumes) {
        ArrayList returnList = Lists.newArrayList();
        for (SsoUIMume mume : ssoUIMumes) {
            returnList.add(mume);
            if (mume.getChild() == null || mume.getChild().isEmpty()) continue;
            returnList.addAll(this.traversal(mume.getChild()));
        }
        return returnList;
    }
}

